/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer.builtin;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.function.BiConsumer;
import net.minecraft.class_11659;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.cache.model.GeoQuad;
import software.bernie.geckolib.cache.model.GeoVertex;
import software.bernie.geckolib.cache.model.cuboid.CuboidGeoBone;
import software.bernie.geckolib.cache.model.cuboid.GeoCube;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.base.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public class CustomBoneTextureGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final String boneName;
    protected final class_2960 texture;

    public CustomBoneTextureGeoLayer(GeoRenderer<T, O, R> renderer, String boneName, class_2960 texture) {
        super(renderer);
        this.boneName = boneName;
        this.texture = texture;
    }

    @Override
    protected class_2960 getTextureResource(R renderState) {
        return this.texture;
    }

    protected @Nullable class_1921 getRenderType(R renderState, class_2960 texture) {
        return this.renderer.getRenderType(renderState, texture);
    }

    @Override
    @ApiStatus.Internal
    public void preRender(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
        if (renderPassInfo.willRender()) {
            renderPassInfo.addBoneUpdater((renderPassInfo1, snapshots) -> snapshots.get(this.boneName).ifPresent(bone -> {
                bone.skipRender(true);
                bone.skipChildrenRender(false);
            }));
        }
    }

    @Override
    public void addPerBoneRender(RenderPassInfo<R> renderPassInfo, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        if (renderPassInfo.willRender()) {
            renderPassInfo.model().getBone(this.boneName).filter(CuboidGeoBone.class::isInstance).ifPresentOrElse(bone -> consumer.accept((GeoBone)bone, this::renderBone), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for CustomBoneTextureGeoLayer: {}, skipping", (Object)this.boneName));
        }
    }

    protected void renderBone(RenderPassInfo<R> renderPassInfo, GeoBone bone, class_11659 renderTasks) {
        R renderState = renderPassInfo.renderState();
        class_2960 boneTexture = this.getTextureResource(renderState);
        class_2960 baseTexture = this.renderer.getTextureLocation(renderState);
        IntIntPair boneTextureSize = RenderUtil.getTextureDimensions(boneTexture);
        IntIntPair baseTextureSize = RenderUtil.getTextureDimensions(baseTexture);
        float widthRatio = (float)baseTextureSize.firstInt() / (float)boneTextureSize.firstInt();
        float heightRatio = (float)baseTextureSize.secondInt() / (float)boneTextureSize.secondInt();
        int packedLight = renderPassInfo.packedLight();
        int packedOverlay = renderPassInfo.packedOverlay();
        int renderColor = renderPassInfo.renderColor();
        class_1921 renderType = this.getRenderType(renderState, boneTexture);
        if (renderType != null) {
            renderTasks.method_73483(renderPassInfo.poseStack(), renderType, (pose, buffer) -> {
                class_4587 poseStack = new class_4587();
                poseStack.method_23760().method_66521(pose);
                poseStack.method_22903();
                RenderUtil.prepMatrixForBone(poseStack, bone);
                bone.updateBonePositionListeners(poseStack, renderPassInfo);
                for (GeoCube cube : ((CuboidGeoBone)bone).cubes) {
                    this.renderCube(cube, poseStack, buffer, packedLight, packedOverlay, renderColor, widthRatio, heightRatio);
                }
                poseStack.method_22909();
            });
        }
    }

    @ApiStatus.Internal
    public void renderCube(GeoCube cube, class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, int renderColor, float widthRatio, float heightRatio) {
        cube.translateToPivotPoint(poseStack);
        cube.rotate(poseStack);
        cube.translateAwayFromPivotPoint(poseStack);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(quad.normalVec());
            RenderUtil.fixInvertedFlatCube(cube, normal);
            this.renderQuad(quad, poseState, normal, vertexConsumer, packedLight, packedOverlay, renderColor, widthRatio, heightRatio);
        }
    }

    @ApiStatus.Internal
    protected void renderQuad(GeoQuad quad, Matrix4f pose, Vector3f normal, class_4588 vertexConsumer, int packedLight, int packedOverlay, int renderColor, float widthRatio, float heightRatio) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector4f vector4f = pose.transform(new Vector4f(vertex.posX(), vertex.posY(), vertex.posZ(), 1.0f));
            vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU() * widthRatio, vertex.texV() * heightRatio, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }
}

